package main

import (
	"context"
	"fmt"
	"os"

	"mydemo/pkg/fio/client"
	"mydemo/pkg/fio/client/localmarket"
	"mydemo/pkg/fio/models"
)

func main() {
	// Validate argument count
	if len(os.Args) != 3 {
		fmt.Println("Must provide a planet name and resource ticker")
		fmt.Printf("Example: %s Katoa SF\n", os.Args[0])
		os.Exit(1)
	}

	// Extract arguments
	planet := os.Args[1]
	material := os.Args[2]

	// Use the API client generated by swagger
	fioc := client.Default.Localmarket

	// Get all ads from given planet. GetAdsAt was generated by swagger.
	ok, empty, err := fioc.GetAdsAt(&localmarket.GetAdsAtParams{
		Planet:  planet,
		Context: context.TODO(),
	})

	// Something went wrong calling to FIO
	if err != nil {
		fmt.Println(err)
		os.Exit(2)
	}

	// No ads at all. Probably a planet name type.
	if empty != nil {
		fmt.Printf("No ads at %s (is planet name correct?)\n", planet)
		os.Exit(2)
	}

	var matchingBuy []*models.BuySellAd
	var matchingSell []*models.BuySellAd

	// Filter Buy Ads
	for _, ad := range ok.GetPayload().BuyingAds {
		if ad.MaterialTicker == material {
			matchingBuy = append(matchingBuy, ad)
		}
	}

	// Filter Sell Ads
	for _, ad := range ok.GetPayload().SellingAds {
		if ad.MaterialTicker == material {
			matchingSell = append(matchingSell, ad)
		}
	}

	// Print the summary
	fmt.Printf("Found %d buy and %d sell ads for %s at %s\n", len(matchingBuy), len(matchingSell), material, planet)
}
